﻿var filterDefinition;

$(document).ready(function () {
    if ($("#HiddenFieldSampleId").val() == 0) {
        filterDefinition = a4.parent().panelistFilter.getFilter();
    }

    if ($("#RadioButtonListExportPanelists .element").length > 1) {
        $(".h-downloadButton").on("click", function () {
            requestFile();
        });
    }
    else {
        requestFile();
    }
});

function requestFile() {
    var sampleId = $("#HiddenFieldSampleId").val();
    if (sampleId != 0) {
        filterDefinition = "";
    }

    var exportRadioValue = $('#RadioButtonListExportPanelists input[type=radio]:checked').val();
    var params = {};
    var actionName = "";
    var onSuccessCallback;

    switch (exportRadioValue) {
        case "0": //Simple Export
            params = { "filterDef": JSON.stringify(filterDefinition), "sampleId": sampleId };
            actionName = "CreatePanelistExportTask";
            onSuccessCallback = function (result) {
                a4.parent().location.assign(a4.getAction("Index", "PanelistExportations", "Panel"));
            };
            break;

        default: //Custom Export
            params = { "customExportId": exportRadioValue, "filterDef": JSON.stringify(filterDefinition), "sampleId": sampleId };
            actionName = "GenerateCustomExportFile";
            onSuccessCallback = function (result) {
                if (result != null && result.length > 0) {
                    var src = a4.getAction("ExportPanelists", "Panelists", "Panel", { GetFile: result });

                    modalDialog.close();
                    a4.hideBusyBox();
                    a4.parent().location.replace(src);
                }
            };
            break;
    }

    a4.showBusyBox();

    a4.callServerMethod(a4.getAction(actionName, "Panelists", "Panel"), params, onSuccessCallback, null,
    {
        complete: function (jqXHR, textStatus) {
            if (textStatus == "timeout") {
                a4.showErrorMessage(resources.TimeoutErrorMessage);
            }
        }
    });
}